// Attract-Mode layout theme SDarcadeModVert
// Inspired by the Arcade SD multiboard
// SDarcade original theme by jedione
// SDarcadeModVert version by dee2eR

class UserConfig
{ 
</ label="Simulated monitor bezel", help="add bezel",options="true,false", order=3 /> bezel="false";
</ label="Background music or none", help="toggle music", options="music, none,", order=1 /> enable_music="none";
</ label="Simulated scanlines", help="toggle scanlines", options="true,false", order=2 /> scanlines="false";
</ label="MSG#2 = freeplay", help="toggle freeplay", options="true,false", order=9 /> freeplay="false";
// line above credits line text
</ label="Message #1", help="Message to display flashing at bottom of screen", order=7 />
	msg1="select game with joystick";
// credits line text
</ label="Message #2", help="Message to display at bottom of screen", order=8 />
	msg2="credits 0  wait for game to coin up";
}
local my_config = fe.get_config();

//set screen
local flx = fe.layout.width;
local fly = fe.layout.height;
local flw = fe.layout.width;
local flh = fe.layout.height;

//set vertical orientation
fe.layout.orient=RotateScreen.Right;

//load modules
fe.load_module( "fade" );
fe.load_module("animate");
fe.load_module("carrier");

//starfield
fe.do_nut("scripts/star.nut");

//game logo wheel images
//local marquee = fe.add_artwork( "wheel", flx*0.150, fly*-0.500, flw*0.700, flh*0.200 );
local marquee = fe.add_artwork( "wheel", flx*0.150, 50, flw*0.700, flh*0.200 );
local marquee_scale_cfg = {
	when =Transition.ToNewSelection,
	property = "scale",
	start = 0.0,
	end = 0.9,
	time = 0700,
	tween = Tween.Linear,
}
local marquee_move_cfg = {
	when =Transition.ToNewSelection,
	property = "y",
	start = fly*0.250,
	end = fly*0.090,
	time = 0700 ,
}	
animation.add( PropertyAnimation( marquee, marquee_scale_cfg ) );
animation.add( PropertyAnimation( marquee, marquee_move_cfg ) );

//background for scanlines if selected
if (my_config["scanlines"] == "true" )
{
local bg = fe.add_image( "images/scanwhite.png", 0, 0, flw, flh );
}

//moving preview images
local carrier = Carrier( -50, 170, 820, 200, 3, 3, 30, 0, 0 )

//line above credits line text
local pulse = fe.add_text( my_config["msg1"], flx*0.000, fly*0.835, flw*1.000, flh*0.050 );
local pulse_text_cfg = {
	when =Transition.ToNewList,
	property = "alpha",
	start = 10, 
	end = 255,
	time = 2000,
	tween = Tween.Linear,
	pulse = true,
	font = "ARCADE",
}
animation.add( PropertyAnimation( pulse, pulse_text_cfg ) );
pulse.font = "ARCADE";
pulse.charsize = 20;
pulse.alpha= 210;

//credit line text
if (my_config["freeplay"] == "true" )
{
local text = fe.add_text("freeplay", flx*0.000, fly*0.920, flw*0.500, flh*0.050 );
text.font="ARCADE";
text.charsize = 20;
text.alpha = 200;
}
if (my_config["freeplay"] == "false" )
{
local text = fe.add_text( my_config["msg2"], flx*0.000, fly*0.920, flw*1.000, flh*0.050 );
text.font="ARCADE";
text.charsize = 20;
text.alpha = 200;
}

//colourful selection box
fe.do_nut("scripts/box.nut");

//scanlines if selected
if (my_config["scanlines"] == "true" )
{
local bg = fe.add_image( "images/scanline.png", 0, 0, flw, flh );
local bg = fe.add_image( "images/crt.png", 0, 0, flw, flh );
}

//bezel art if selected
if ( my_config["bezel"] == "true" )
{
local bez = fe.add_image( "images/bez.png", 0, 0, flw, flh );
}

//background music if selected
if ( my_config["enable_music"] == "none" )
{
local mysong = fe.add_sound("")
}
if ( my_config["enable_music"] == "music" )
{
local mysong = fe.add_sound("music/music.mp3");
mysong.loop = true;
mysong.playing = true;
}

//game select sound
function select_sound( ttype, var, ttime ) {
 switch ( ttype ) {

  case Transition.ToNewSelection:
	      local sound = fe.add_sound("game.mp3");
	      sound.playing=true;
  break;
  }
 return false;
}
fe.add_transition_callback( "select_sound" );

