// Modified NOT ORIGINAL please do not bother the original authors if this code sucks
// Originally from layout theme "Warp"
// Starfield code adapted from: "Starfield" by Christophe Rsign
// http://www.chromeexperiments.com/detail/starfield/?f=`
// http://www.chiptune.com/starfield/starfield.html
//
// Modified to animate the background starfield for SDarcadeModVert as original star.nut
// doesn't work on RaspberryPi & this one does

class UserConfig {
	</ label="Controls: Up", help="Set controls for navigating the starfield", is_input="yes", order=1 />
	up="";

	</ label="Controls: Down", help="Set controls for navigating the starfield", is_input="yes", order=2 />
	down="";

	</ label="Controls: Left", help="Set controls for navigating the starfield", is_input="yes", order=3 />
	left="";

	</ label="Controls: Right", help="Set controls for navigating the starfield", is_input="yes", order=4 />
	right="";

	</ label="Speed", help="Speed of travel through starfield (-25 to 25, default=4)", order=5 />
	speed="4";
}

local my_config = fe.get_config();

const n=256;
local x=fe.layout.width/2;
local y=fe.layout.height/2;
local z=(fe.layout.width+fe.layout.height)/2;

local star_colour_ratio=1.0/z;
local mouse_x=x;
local mouse_y=y;
local star_ratio=256;
local base_speed = my_config["speed"].tofloat(); 
if ( abs( base_speed ) > 25 ) // speed limits...
	base_speed=25.0;

local star_speed=base_speed;

local star = array(n);

function my_rand()
{
	return ( rand() % 1000 ) / 1000.0;
}

function my_round( num )
{
	return ( num + 0.5 ).tointeger();
}

function my_set_colour( star, val )
{
	local temp = val * 255;
	if ( temp > 255 )
		temp = 255;

	star.set_rgb( temp, temp, temp );
}

local resource = fe.add_image( "images/dot.png", -1, -1, 1, 1 );

for(local i=0;i<n;i++)
{
	star[i]=array(7);
	star[i][0]=my_rand()*fe.layout.width*2-x*2;
	star[i][1]=my_rand()*fe.layout.height*2-y*2;
	star[i][2]=my_round( my_rand()*z );
	star[i][3]=0;
	star[i][4]=0;
	star[i][5]=fe.add_clone( resource );
	star[i][6]=fe.add_clone( resource );

	// make 10% of the stars a bit bigger
	if ( rand() % 10 == 0 )
	{
		star[i][5].width = star[i][5].height=2;
		star[i][6].width = star[i][6].height=2;
	}
}

local snap_width = 240;
local snap_height = 152;

local snap_x = ( fe.layout.width - snap_width ) / 2;
//local snap_y = ( fe.layout.height - snap_height ) / 2;
local snap_y = 194

local surf = fe.add_surface( 500, 80 );
surf.set_pos( 70, 375, 500, 80 );
surf.pinch_x = -180;

function anim()
{
	for(local i=0;i<n;i++)
	{
		local test=true;
		local star_x_save=star[i][3];
		local star_y_save=star[i][4];

		star[i][0]+=mouse_x>>4;

		if(star[i][0] > x <<1)
		{
			star[i][0]-=fe.layout.width<<1;
			test=false;
		}
		if(star[i][0] < -x<<1)
		{
			star[i][0]+=fe.layout.width<<1;
			test=false;
		}

		star[i][1]+=mouse_y>>4;

		if(star[i][1] > y<<1)
		{
			star[i][1]-=fe.layout.height<<1;
			test=false;
		}
		if(star[i][1] < -y<<1)
		{
			star[i][1]+=fe.layout.height<<1;
			test=false;
		}

		star[i][2]-=star_speed;

		if(star[i][2] > z)
		{
			star[i][2]-=z;
			test=false;
		}
		if(star[i][2] < 0)
		{
			star[i][2]+=z;
			test=false;
		}

		star[i][3]=x+(star[i][0]/star[i][2])*star_ratio;
		star[i][4]=y+(star[i][1]/star[i][2])*star_ratio;

		local temp = (1-star_colour_ratio*star[i][2])*2;
		my_set_colour( star[i][5], temp );

		if(star_x_save>0
			&&star_x_save<fe.layout.width
			&&star_y_save>0
			&&star_y_save<fe.layout.height
                        &&test)
		{
			star[i][6].visible = true;

			my_set_colour( star[i][6], temp );

			star[i][5].x = star[i][3];
			star[i][5].y = star[i][4];

			star[i][6].x = star_x_save;
			star[i][6].y = star_y_save;
		}
		else
		{
			star[i][5].x = star[i][3];
			star[i][5].y = star[i][4];
			star[i][6].visible = false;
		}
	}
}

fe.add_ticks_callback( "my_tick" );

local accumulate_x=0;

function my_tick( ttime )
{
	local up = fe.get_input_pos( my_config["up"] );
	local down = fe.get_input_pos( my_config["down"] );
	local left = fe.get_input_pos( my_config["left"] );
	local right = fe.get_input_pos( my_config["right"] );
	local cursor_x=x;
	local cursor_y=y;
	if ( up > 0 )
	{
		cursor_y = ( y + ( up / 100.0 ) * y ).tointeger();
		snap.y = snap_y - ( up / 100.0 ) * 4;
	}
	if ( down > 0 )
	{
		cursor_y = ( y - ( down / 100.0 ) * y ).tointeger();
		snap.y = snap_y + ( down / 100.0 ) * 4;
	}

	if ( left > 0 )
	{
		cursor_x = ( x + ( left / 100.0 ) * x ).tointeger();
		snap.x = snap_x - ( left / 100.0 ) * 4;
		accumulate_x -= left / 8;
	}
	if ( right > 0 )
	{
		cursor_x = ( x - ( right / 100.0 ) * y ).tointeger();
		snap.x = snap_x + ( right / 100.0 ) * 4;
		accumulate_x += right / 8;
	}

	mouse_x=cursor_x-x;
	mouse_y=cursor_y-y;

	anim();
}
