#!/bin/bash

# resolution switching game launcher script for advmame
# WARNING use at your own risk!

function contains() {
    local n=$#
    local value=${!n}
    for ((i=1;i < $#;i++)) {
        if [ "${!i}" == "${value}" ]; then
            echo "y"
            return 0
        fi
    }
    echo "n"
    return 1
}

# add games which render wierdly using dispmanx to nosdl to run them on the framebuffer (eg. gorf)
nosdl=("tcobra2" "sundance" "spacedem" "spacefb" "getstar" "aso" "victroad" "venture" "tnk3" "suprglob" "splat" "spectar" "jedi" "playball" "nyny" "mrflea" "mysticm" "mustache" "mtrap" "megadon" "mayday" "ldrun3" "ladyfrog" "dogosoke" "spaceg" "tacscan" "tempest" "tumblep" "smashtv" "gravitar" "mpatrol" "bbprot" "tshoot" "mating" "getstarb" "gekirido" "defence" "defender" "crmaze" "cchasm" "colony7" "alienar" "bmcbowl" "blast30" "blaster" "robotron" "gorf" "splash")

# games in this array will run in advmame 3.0 rather than 1.4 this will fix supported toaplan samples
advThree=("outfxies" "vimana" "samesame" "tekipaki" "batsugun" "dogyuun" "ghox" "vfive")

# start hotkeys for extra functions
hotkeys start >/dev/null 2>&1
clear

list=/boot/launchers/mameinfo.txt
less $list | while read i
do
    echo | grep -A5 -P -w "rom=$1" $list > /var/cache/apt/tmp.txt
    type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
    screen=`echo ${type:6:-1}`
    rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
    rot=`echo ${rotate:8:-1}`
    height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
    h=`echo ${height:8:-1}`
#    refresh=`echo | grep -A0 -P "refresh" /var/cache/apt/tmp.txt`
#    r=`echo ${refresh:9:-1}`

    if [ $rot == 90 ] || [ $rot == 270 ] || [ $screen == vector ] || [ $h -gt 288 ]; then
        echo rotated, vector or med/high res game -- running interlaced
    else
	if [ $h -gt 264 ]; then
            echo switching to 288p
##	    tvservice -e "CEA 23 HDMI" & sleep 3
# Use custom 288p mode instead of CEA 23 as it better matches the 240p mode on Scart TV
# Custom mode defined in /boot/config.txt
            vcgencmd hdmi_timings 1920 1 8 192 280 288 1 6 3 16 0 0 2 50 0 37560000 1
	    tvservice -e "CEA 65 HDMI" & sleep 3
	    fbset -depth 8 && fbset -depth 16
            fbset -g 960 288 960 288 16
        else    
             if [ $h -gt 248 ]; then  
                 echo switching to 256p
                 vcgencmd hdmi_timings 1920 1 113 192 175 256 1 6 3 16 0 0 2 56 0 37560000 1
                 tvservice -e "CEA 65 HDMI" & sleep 3
                 fbset -depth 8 && fbset -depth 16
                 fbset -g 960 256 960 256 16
             else
                echo switching to 240p
                tvservice -e "CEA 8 HDMI" & sleep 3
                fbset -depth 8 && fbset -depth 16
                fbset -g 720 240 720 240 16
             fi
        fi
    fi
    exit
#    fi
done

# re-read needed variables from temporary file as they're no longer in memory after the loop is over
rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
rot=`echo ${rotate:8:-1}`
#type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
#screen=`echo ${type:6:-1}`
#height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
#h=`echo ${height:8:-1}`

#we don't want full width stretching for a vertical game
if [ $rot == 90 ] || [ $rot == 270 ]; then
    export -n SDL_DISPMANX_IGNORE_RATIO=1
fi

#reload now loading message
/boot/nowloadn.sh >/dev/tty1 &

## launch game    
#for some reason advmame gorf (and prob others) and dispmanx have interesting issues so run without SDL_DISPMANX
#add games to nosdl at the top of the file if they cause advmame to render on an angle or other wierd behaviour
#if [ $1 == gorf ]; then
if [ $(contains "${nosdl[@]}" "$1") == "y" ]; then
    advmame $1
else
    if [ $(contains "${advThree[@]}" "$1") == "y" ]; then
        advmame.3.0 $1 -cfg ~/.advance/advmame.sdl.rc
    else
        advmame $1 -cfg ~/.advance/advmame.sdl.rc
    fi
fi

#if changed restore full width stretching
if [ $rot == 90 ] || [ $rot == 270 ]; then
    export SDL_DISPMANX_IGNORE_RATIO=1
fi

# stop hotkeys for menus
hotkeys stop

# resolution back to 720x480i
tvservice -e "CEA 6 HDMI" & sleep 3
fbset -depth 8 && fbset -depth 16
fbset -g 720 480 720 480 16

exit
