#!/bin/bash

# custom resolution game launcher script
# WARNING use at your own risk!

# start hotkeys for extra functions
hotkeys start >/dev/null 2>&1
clear

list=/boot/launchers/mameinfo.txt
less $list | while read i
do
    echo | grep -A5 -P -w "rom=$1" $list > /var/cache/apt/tmp.txt
    type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
    screen=`echo ${type:6:-1}`

    rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
    rot=`echo ${rotate:8:-1}`

    height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
    h=`echo ${height:8:-1}`

    if [ $rot == 90 ] || [ $rot == 270 ] || [ $screen == vector ] || [ $h -gt 288 ]; then
        echo rotated, vector or med/high res game -- running interlaced
    else
	    echo switching to 720x240p
	    tvservice -e "CEA 8 HDMI"
    fi
    exit
done

#reload now loading message
/boot/nowloadn.sh >/dev/tty1 

rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
rot=`echo ${rotate:8:-1}`

type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
screen=`echo ${type:6:-1}`

height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
h=`echo ${height:8:-1}`

# launch game
if [ $rot == 90 ] || [ $rot == 270 ] || [ $screen == vector ] || [ $h -gt 288 ]; then
    /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-fba-next/fba_libretro_vert.so -c /home/pi/.config/retroarch/fba_libretro_vert.cfg /boot/roms/fba/$1.zip
else
    if [ $h == 224 ]; then
        /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-fba-next/fba_libretro_224.so -c /home/pi/.config/retroarch/fba_libretro_224.cfg /boot/roms/fba/$1.zip
    else
        /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-fba-next/fba_libretro.so -c /home/pi/.config/retroarch/fba_libretro.so.cfg /boot/roms/fba/$1.zip
    fi
fi

# stop hotkeys for menus
hotkeys stop

# and back to 720x480i
tvservice -e "CEA 6 HDMI" & sleep 3
fbset -depth 8 && fbset -depth 16
fbset -g 720 480 720 480 16

exit
