#!/bin/bash

# custom resolution game launcher script
# WARNING use at your own risk!

# start hotkeys for extra functions
hotkeys start >/dev/null 2>&1
clear

list=/boot/launchers/mameinfo.txt
less $list | while read i
do
    echo | grep -A5 -P -w "rom=$1" $list > /var/cache/apt/tmp.txt
    type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
    #echo $type
    screen=`echo ${type:6:-1}`
#    echo $screen
    rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
    rot=`echo ${rotate:8:-1}`
    #echo $rot
    height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
    h=`echo ${height:8:-1}`
#    echo $h
#    refresh=`echo | grep -A0 -P "refresh" /var/cache/apt/tmp.txt`
#    r=`echo ${refresh:9:-1}`
#    echo $r

    if [ $rot == 90 ] || [ $rot == 270 ] || [ $screen == vector ] || [ $h -gt 288 ]; then
        echo rotated, vector or med/high res game -- running interlaced
    else
	if [ $h -gt 264 ]; then
            echo switching to 288p
##	    tvservice -e "CEA 23 HDMI" & sleep 3
# Use custom 288p mode instead of CEA 23 as it better matches the 240p mode on Scart TV
# Custom mode defined in /boot/config.txt
            vcgencmd hdmi_timings 1920 1 8 192 280 288 1 6 3 16 0 0 2 50 0 37560000 1
	    tvservice -e "CEA 65 HDMI" & sleep 3
	    fbset -depth 8 && fbset -depth 16
            fbset -g 960 288 960 288 16
        else    
             if [ $h -gt 248 ]; then  
                 echo switching to 256p
                 vcgencmd hdmi_timings 1920 1 113 192 175 256 1 6 3 16 0 0 2 56 0 37560000 1
                 tvservice -e "CEA 65 HDMI" & sleep 3
                 fbset -depth 8 && fbset -depth 16
                 fbset -g 960 256 960 256 16
             else
                echo switching to 240p
                tvservice -e "CEA 8 HDMI" & sleep 3
                fbset -depth 8 && fbset -depth 16
                fbset -g 720 240 720 240 16
             fi
        fi
    fi
    exit
#    fi
done

#reload now loading message
/boot/nowloadn.sh >/dev/tty1 

type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
screen=`echo ${type:6:-1}`
rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
rot=`echo ${rotate:8:-1}`
height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
h=`echo ${height:8:-1}`
#echo $h
# launch game
if [ $rot == 90 ] || [ $rot == 270 ] || [ $screen == vector ] || [ $h -gt 288 ]; then
    /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-mame2003/mame2003_libretro_480.so --config /home/pi/.config/retroarch/mame078_libretro_480.cfg /home/pi/.mame078/rom/$1.zip
else
    if [ $h == 254 ]; then
    /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-mame2003/mame2003_libretro_256.so --config /home/pi/.config/retroarch/mame078_libretro_256.cfg /home/pi/.mame078/rom/$1.zip
    else
        if [ $h == 224 ]; then
            /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-mame2003/mame2003_libretro_224.so --config /home/pi/.config/retroarch/mame078_libretro_224.cfg /home/pi/.mame078/rom/$1.zip
        else
            /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-mame2003/mame2003_libretro.so --config /home/pi/.config/retroarch/mame078_libretro.cfg /home/pi/.mame078/rom/$1.zip
        fi
    fi
fi

# stop hotkeys for menus
hotkeys stop

# and back to 720x480i
tvservice -e "CEA 6 HDMI" & sleep 3
fbset -depth 8 && fbset -depth 16
fbset -g 720 480 720 480 16

exit
