#!/bin/bash

# resolution switching game launcher script for mame
# WARNING use at your own risk!

# start hotkeys for extra functions
hotkeys start >/dev/null 2>&1
clear

list=/boot/launchers/mameinfo.txt
less $list | while read i
do
    echo | grep -A5 -P -w "rom=$1" $list > /var/cache/apt/tmp.txt
    type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
    screen=`echo ${type:6:-1}`
    rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
    rot=`echo ${rotate:8:-1}`
    height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
    h=`echo ${height:8:-1}`
#    refresh=`echo | grep -A0 -P "refresh" /var/cache/apt/tmp.txt`
#    r=`echo ${refresh:9:-1}`

    if [ $rot == 90 ] || [ $rot == 270 ] || [ $screen == vector ] || [ $h -gt 288 ]; then
        echo rotated, vector or med/high res game -- running interlaced
    else
	if [ $h -gt 264 ]; then
            echo switching to 288p
##	    tvservice -e "CEA 23 HDMI" & sleep 3
# Use custom 288p mode instead of CEA 23 as it better matches the 240p mode on Scart TV
# Custom mode defined in /boot/config.txt
            vcgencmd hdmi_timings 1920 1 8 192 280 288 1 6 3 16 0 0 2 50 0 37560000 1
	    tvservice -e "CEA 65 HDMI" & sleep 3
	    fbset -depth 8 && fbset -depth 16
            fbset -g 960 288 960 288 16
        else    
             if [ $h -gt 248 ]; then  
                 echo switching to 256p
                 vcgencmd hdmi_timings 1920 1 113 192 175 256 1 6 3 16 0 0 2 56 0 37560000 1
                 tvservice -e "CEA 65 HDMI" & sleep 3
                 fbset -depth 8 && fbset -depth 16
                 fbset -g 960 256 960 256 16
             else
                echo switching to 240p
                tvservice -e "CEA 8 HDMI" & sleep 3
                fbset -depth 8 && fbset -depth 16
                fbset -g 720 240 720 240 16
             fi
        fi
    fi
    exit
done

#reload now loading message
/boot/nowloadn.sh >/dev/tty1 

# re-read needed variables from temporary file as they're no longer in memory after the loop is over
rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
rot=`echo ${rotate:8:-1}`
#type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
#screen=`echo ${type:6:-1}`
height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
h=`echo ${height:8:-1}`

## launch game
cd /home/pi/mame181
#we don't want full width stretching for a vertical game
if [ $rot == 90 ] || [ $rot == 270 ]; then
    ./mame $1 -keepaspect -unevenstretch
else
    ./mame $1 -intscaley 1 -intoverscan -uifont uismall.bdf 
#    ./mame $1 -scalemode yv12 
#    ./mame $1 -intscaley 1 -unevenstretchx -uifont uismall.bdf
fi
cd ..

# stop hotkeys for menus
hotkeys stop

# resolution back to 720x480i
tvservice -e "CEA 6 HDMI" & sleep 3
fbset -depth 8 && fbset -depth 16
fbset -g 720 480 720 480 16

exit
