#!/bin/bash

# custom resolution game launcher script
# WARNING use at your own risk!

# start hotkeys for extra functions
hotkeys start >/dev/null 2>&1
clear

# change sdl driver to fix a keyboard bug with mame4all
export SDL1_VIDEODRIVER=fbcon

list=/boot/launchers/mameinfo.txt
less $list | while read i
do
    echo | grep -A5 -P -w "rom=$1" $list > /var/cache/apt/tmp.txt
    type=`echo | grep -A0 -P "type" /var/cache/apt/tmp.txt`
    #echo $type
    screen=`echo ${type:6:-1}`
#    echo $screen
    rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
    rot=`echo ${rotate:8:-1}`
    #echo $rot
    height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
    h=`echo ${height:8:-1}`
#    echo $h
#    refresh=`echo | grep -A0 -P "refresh" /var/cache/apt/tmp.txt`
#    r=`echo ${refresh:9:-1}`
#    echo $r

    if [ $rot == 90 ] || [ $rot == 270 ] || [ $screen == vector ] || [ $h -gt 288 ]; then
        echo rotated, vector or med/high res game -- running interlaced
    else
	if [ $h -gt 264 ]; then
            echo switching to 288p
##	    tvservice -e "CEA 23 HDMI" & sleep 3
# Use custom 288p mode instead of CEA 23 as it better matches the 240p mode on Scart TV
# Custom mode defined in /boot/config.txt
            vcgencmd hdmi_timings 1920 1 8 192 280 288 1 6 3 16 0 0 2 50 0 37560000 1
	    tvservice -e "CEA 65 HDMI" & sleep 3
	    fbset -depth 8 && fbset -depth 16
            fbset -g 960 288 960 288 16
        else    
             if [ $h -gt 248 ]; then  
                 echo switching to 256p
                 vcgencmd hdmi_timings 1920 1 113 192 175 256 1 6 3 16 0 0 2 56 0 37560000 1
                 tvservice -e "CEA 65 HDMI" & sleep 3
                 fbset -depth 8 && fbset -depth 16
                 fbset -g 960 256 960 256 16
             else
                echo switching to 240p
                tvservice -e "CEA 8 HDMI" & sleep 3
                fbset -depth 8 && fbset -depth 16
                fbset -g 720 240 720 240 16
             fi
        fi
    fi
    exit
#    fi
done

#reload now loading message
/boot/nowloadn.sh >/dev/tty1 

# setup variables for game launch
height=`echo | grep -A0 -P "height" /var/cache/apt/tmp.txt`
h=`echo ${height:8:-1}`
width=`echo | grep -A0 -P "width" /var/cache/apt/tmp.txt`
w=`echo ${width:7:-1}`
#echo $w
rotate=`echo | grep -A0 -P "rotate" /var/cache/apt/tmp.txt`
rot=`echo ${rotate:8:-1}`
#echo $rot

# launch game
if [ $rot == 90 ] || [ $rot == 270 ]; then
    /home/pi/mame4all/mame "$1" "-display_smooth_stretch"
else
    if [ $1 == wboy ]; then
        /home/pi/mame4all/mame3x $1
    else
    if [ $h -lt 241 ]; then
        /home/pi/mame4all/mamewide "$1" "-display_smooth_stretch"
    else
	if [ $h -gt 288 ]; then
	    /home/pi/mame4all/mamewide "$1" "-display_smooth_stretch"
	else
	    if [ $w -lt 241 ]; then
	        /home/pi/mame4all/mame3x $1
	    else
		/home/pi/mame4all/mame $1
	    fi
	fi
    fi
    fi
fi

# stop hotkeys for menus
hotkeys stop

# and back to 720x480i
tvservice -e "CEA 6 HDMI" & sleep 3
fbset -depth 8 && fbset -depth 16
fbset -g 720 480 720 480 16

# restore dispmanx video driver
export SDL1_VIDEODRIVER=dispmanx

exit
