#!/bin/bash

# custom resolution game launcher script
# WARNING use at your own risk!

function contains() {
    local n=$#
    local value=${!n}
    for ((i=1;i < $#;i++)) {
        if [ "${!i}" == "${value}" ]; then
            echo "y"
            return 0
        fi
    }
    echo "n"
    return 1
}

# Add games to be run in 480i to this array
intrlace=("tekken3.iso" "mk4.iso" "capsnk.bin" "shienryu.bin")
# Games to be run at 228 lines non interlaced
totoeght=("sfex2p.iso")
# In case of other special case
speccase=()

# start hotkeys for extra functions
hotkeys start >/dev/null 2>&1
clear

#check if game should run in 480i
if [ $(contains "${intrlace[@]}" "$*") == "y" ]; then
    #reload now loading message
    /boot/nowloadn.sh >/dev/tty1 
    #launch game without changing out of 480i
    /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-pcsx-rearmed/libretro.so -c /home/pi/.config/retroarch/pcsx_rearmed.cfg /boot/roms/consoles/pcsx-rearmed/"$*"
else
    # switch to 240p
    tvservice -e "CEA 8 HDMI" & sleep 3
    fbset -depth 8 && fbset -depth 16
    fbset -g 720 240 720 240 16

    #reload now loading message
    /boot/nowloadn.sh >/dev/tty1 
    
    # launch game
    if [ $(contains "${totoeght[@]}" "$*") == "y" ]; then
        /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-pcsx-rearmed/libretro.so -c /home/pi/.config/retroarch/pcsx_rearmed228.cfg /boot/roms/consoles/pcsx-rearmed/"$*"
    else
        if [ $(contains "${speccase[@]}" "$*") == "y" ]; then
            /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-pcsx-rearmed/libretro.so -c /home/pi/.config/retroarch/pcsx_rearmed_speccase.cfg /boot/roms/consoles/pcsx-rearmed/"$*"
        else
            /home/pi/.config/retroarch/bin/retroarch -L /home/pi/.config/retroarch/cores/lr-pcsx-rearmed/libretro.so -c /home/pi/.config/retroarch/pcsx_rearmed240.cfg /boot/roms/consoles/pcsx-rearmed/"$*"
        fi
    fi
    
    # stop hotkeys for menus
    hotkeys stop
    # and back to 720x480i
    tvservice -e "CEA 6 HDMI" & sleep 3
    fbset -depth 8 && fbset -depth 16
    fbset -g 720 480 720 480 16

fi

exit
